import 'package:flutter/material.dart';
import 'package:get/get.dart';

import '../../../../core/route/route.dart';
import '../../../../core/utils/dimensions.dart';
import '../../../../core/utils/my_color.dart';
import '../../../../core/utils/my_strings.dart';
import '../../../../core/utils/style.dart';
import '../../../../data/controller/invoice/invoice_history_controller.dart';
import '../../../../data/repo/invoice/invoice_history_repo.dart';
import '../../../../data/services/api_service.dart';
import '../../../components/app-bar/action_button_icon_widget.dart';
import '../../../components/app-bar/custom_appbar.dart';
import '../../../components/custom_loader/custom_loader.dart';
import '../../../components/no_data.dart';
import 'widget/invoice_card.dart';
import 'widget/invoices_bottom_sheet.dart';

class InvoiceScreen extends StatefulWidget {
  const InvoiceScreen({Key? key}) : super(key: key);

  @override
  State<InvoiceScreen> createState() => _InvoiceScreenState();
}

class _InvoiceScreenState extends State<InvoiceScreen> {
  final ScrollController scrollController = ScrollController();

  void scrollListener() {
    if (scrollController.position.pixels == scrollController.position.maxScrollExtent) {
      if (Get.find<InvoiceHistoryController>().hasNext()) {
        Get.find<InvoiceHistoryController>().loadInvoiceData();
      }
    }
  }

  @override
  void initState() {
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(InvoiceHistoryRepo(apiClient: Get.find()));
    final controller = Get.put(InvoiceHistoryController(invoiceHistoryRepo: Get.find()));

    super.initState();

    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      controller.initialData();
      scrollController.addListener(scrollListener);
    });
  }

  @override
  void dispose() {
    scrollController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<InvoiceHistoryController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.screenBgColor,
        appBar: CustomAppBar(
          title: MyStrings.invoice,
          isTitleCenter: true,
          elevation: 0.1,
          action: [
            ActionButtonIconWidget(
              pressed: () => Get.toNamed(RouteHelper.createInvoiceScreen, arguments: [controller.model.data?.paymentCharge]),
              icon: Icons.add,
            ),
            const SizedBox(width: 10)
          ],
        ),
        body: controller.isLoading
            ? const CustomLoader()
            : controller.invoiceList.isEmpty
                ? Center(
                    child: NoDataWidget(),
                  )
                : RefreshIndicator(
                  onRefresh: () async{
                    controller.initialData();
                  },
                  child: SingleChildScrollView(
                      controller: scrollController,
                      physics: AlwaysScrollableScrollPhysics(parent: const BouncingScrollPhysics()),
                      padding: const EdgeInsets.symmetric(vertical: Dimensions.space20, horizontal: Dimensions.space15),
                      child: ListView.separated(
                          shrinkWrap: true,
                          scrollDirection: Axis.vertical,
                          physics: const NeverScrollableScrollPhysics(),
                          itemCount: controller.invoiceList.length + 1,
                          separatorBuilder: (context, index) => const SizedBox(height: Dimensions.space10),
                          itemBuilder: (context, index) {
                            if (controller.invoiceList.length == index) {
                              return controller.hasNext() ? const CustomLoader(isPagination: true) : const SizedBox();
                            }
                  
                            return InkWell(
                              onTap: () => InvoicesBottomSheet.bottomSheet(context, index, invoiceDataModel: controller.invoiceList[index]),
                              child: InvoiceCard(
                                index: index,
                                invoiceDataModel: controller.invoiceList[index],
                              ),
                            );
                          }),
                    ),
                ),
      ),
    );
  }
}
